#ifndef __jabberserviceprovider_h__
#define __jabberserviceprovider_h__

//#include "Helper.h"
//#include "apcomdef.h"
//#include "JMCommonDependenciesInterface.h"
//#include "JabberWerxCommonEvent.h"
//#include "XmppMgr\XMppMgrInterface.h"


#include "csf/Timer.hpp"
#include "csf/RWLock.hpp"
#include "csf/logger/CSFLogger.hpp"
#include "csfunified/framework/UnifiedFactory.h"
#include "csfunified/services/interface/ContactService.h"
#include "csfunified/services/interface/Contact.h"
#include "csfunified/services/interface/ConfigService.h"
#include "csfunified/services/interface/ConfigValue.h"
#include "csfunified/services/interface/PresenceService.h"
#include "csfunified/services/interface/InstantMessageConversationService.h"
#include "csfunified/services/interface/Credentials.h"
#include "csfunified/services/interface/IMState.h"
#include "csfunified/services/interface/PropertyNotifier.h"
#include <csf/RWLock.hpp>

namespace CSFUnified
{
    class JabberServiceProvider
	{
	public:
		~JabberServiceProvider(void);
        
        static JabberServiceProvider& getInstance();

        void setUnifiedFactory(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory);
        SMART_PTR_NS::shared_ptr<UnifiedFactory> getUnifiedFactory();

        std::string getMyAccount();
        std::string getMyDisplayName();
        std::string getMyEmail();
        std::string getDisplayNameByJabberId(std::string JID);
        std::string getEmailByJabberId(std::string JID);
        std::string getJIDByEmail(std::string email);
        
        SMART_PTR_NS::shared_ptr<Contact> getContact(const std::string& uri);
        IMStateEnum::IMState getIMState(const std::string& uri);
        
        bool isDSPolicyEnable(std::string uri, int& nPolicyResult);
		void autoRespPolicy(std::string uri, int& nPolicyResult);
        bool isIMPolicyEnable(const std::string& uri);
		bool hasDSCapability(std::string uri);
		bool hasIMCapability(std::string uri);
		bool isBuddyOnline(std::string uri);
		bool isCupMode();
		bool isPhoneMode();
        
		bool isWbxMeetingEnabled();
        std::string getDSURL();
		int getSignatureMode();
        
        std::string getConfigValueByKey(const std::string key);
        void setConfigValueByKey(const std::string key, const std::string value);
        
        SMART_PTR_NS::shared_ptr<Credentials> getMeetingCredential();
        void setMeetingCredential(const std::string userName, const csf::SecureString password);
		SMART_PTR_NS::shared_ptr<Credentials> getCustomizedMeetingCredential();
		void setCustomizedMeetingCredential(const std::string userName, const csf::SecureString password);

        void addInMeetingStatus();
        void removeInMeetingStatus();
        void addInWebExMeetingStatus();
        void removeInWebExMeetingStatus();
        void addSharingInWebExMeetingStatus();
        void removeSharingInWebExMeetingStatus();
        void addInDSStatus();
        void removeInDSStatus();
        void addSharingInDSStatus();
        void removeSharingInDSStatus();
        
		virtual void onCapabilityChanged();
        
        void SendCmd_CMRMeetingInvitation(const std::string& JID, const std::string& strCmdMsg, const std::string& htmlMsg, const std::string plainMsg);
        
	public:
		void start();
		void stop();

    public:
        void startPresenceMonitor();
        void stopPresenceMonitor();
        
        void _startPresenceMonitor();
        void _stopPresenceMonitor();
        
    private:
        JabberServiceProvider(void);
        void initDefaultService();

    private:
        csf::RWLock mLock;
        SMART_PTR_NS::shared_ptr<UnifiedFactory> m_unifiedFactory;
        SMART_PTR_NS::shared_ptr<ContactService> m_contactService;
        SMART_PTR_NS::shared_ptr<ConfigService> m_configService;
        SMART_PTR_NS::shared_ptr<PresenceService> m_presenceService;
        
        PropertyNotifierConnectionWPtr m_currentPresenceChange;
        PropertyNotifierConnectionWPtr m_ptrDSTokenChanged;
        csf::RWLock m_Lock;

	};
}

#endif
